<?php
$albumsDir = 'albums/';
$albums = array_filter(glob($albumsDir . '*'), 'is_dir');
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>https://photos.webpages.dk/</title>
<style>
  body {
    font-family: sans-serif;
    background: #515151;
    margin: 0;
    padding: 20px;
    text-align: center;
  }
  h1 {
    margin-bottom: 30px;
  }
  .album-grid {
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
    gap: 25px;
  }
  .album {
    width: 250px;
    text-align: center;
  }

  /* ✅ Fixed square image frame */
  .album .thumb {
    width: 100%;
    aspect-ratio: 1 / 1;           /* make perfect square */
    overflow: hidden;              /* crop overflow */
    border-radius: 8px;
    box-shadow: 0 2px 6px rgba(0,0,0,0.2);
  }

  .album img {
    width: 100%;
    height: 100%;
    object-fit: cover;             /* crop instead of distort */
    transition: transform 0.2s ease;
  }

  .album img:hover {
    transform: scale(1.05);
  }

  .album-title {
    margin-top: 10px;
    font-weight: bold;
    color: #FFFFFF;
  }
  
</style>
</head>
<body LINK='#FFFFFF' ALINK='#FFFFFF' VLINK='#FFFFFF'>
<h1><DIV STYLE='color:orange;'>https://photos.webpages.dk/</DIV></h1>


<div class="album-grid">
<?php foreach ($albums as $albumPath): 
  $albumName = basename($albumPath);
  $images = glob("$albumPath/*.{jpg,jpeg,png,gif}", GLOB_BRACE);
  if (!$images) continue;

  $count = count($images);                // <-- Count images
  $randomImage = $images[array_rand($images)];
?>
  <div class="album">
    <a href="album.php?name=<?php echo urlencode($albumName); ?>">
      <div class="thumb">
        <img src="<?php echo htmlspecialchars($randomImage); ?>" alt="<?php echo htmlspecialchars($albumName); ?>">
      </div>
      <div class="album-title">
        <?php echo htmlspecialchars(ucfirst($albumName)) . " ($count)"; ?>
      </div>
    </a>
  </div>
<?php endforeach; ?>
</div>
<BR />
<DIV STYLE='color:#FFFFFF;font-family:Sans;font-size:16px;'>Made by <A HREF='https://chatgpt.com/' TARGET='_blank'>ChatGPT.com</A>, download the sourcecode <A HREF='https://tutorials.webpages.dk/gallery/' TARGET='_blank'>here</A>..</DIV>


</body>
</html>
